import { Context } from '@satorijs/satori';
import { Registrar } from 'cordis-decorators';
import { selectContext, Selection } from './utility/select-context';

export class SatoriRegistrar<Ctx extends Context> extends Registrar<Ctx> {
  methodDecorators() {
    return {
      ...super.methodDecorators(),
    };
  }

  selectorDecorators() {
    return {
      OnAnywhere: this.decorateTransformer((ctx) => ctx.any()),
      OnNowhere: this.decorateTransformer((ctx) => ctx.never()),
      OnUser: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.user(...values),
      ),
      OnSelf: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.self(...values),
      ),
      OnGuild: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.guild(...values),
      ),
      OnChannel: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.channel(...values),
      ),
      OnPlatform: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.platform(...values),
      ),
      OnPrivate: this.decorateTransformer((ctx, ...values: string[]) =>
        ctx.private(...values),
      ),
      OnSelection: this.decorateTransformer((ctx, selection: Selection) =>
        selectContext(ctx, selection),
      ),
    };
  }

  scopeDecorators() {
    return {
      ...super.scopeDecorators(),
      ...this.selectorDecorators(),
    };
  }
}

export const defaultRegistrarS = new SatoriRegistrar(Context);
