import { defaultRegistrarS } from '../registrar';
import {
  DefaultContext,
  DefaultState,
  ParameterizedContext,
  Next as KoaNext,
} from 'koa';
import { RouterParamContext } from '@koa/router';

export type KoaContext = ParameterizedContext<
  DefaultState,
  DefaultContext & RouterParamContext<DefaultState, DefaultContext>,
  any
>;

const RouterMethod = defaultRegistrarS.decorateMethod(
  'route',
  (
    ctx,
    fun: (ctx: KoaContext, Next: KoaNext) => Promise<any>,
    method:
      | 'get'
      | 'post'
      | 'put'
      | 'delete'
      | 'patch'
      | 'options'
      | 'head'
      | 'all',
    path: string,
  ) => {
    const _path = path.startsWith('/') ? path : `/${path}`;
    return ctx.router[method](_path, (koaCtx, next) => fun(koaCtx, next));
  },
);

export const Get = (path: string) => RouterMethod('get', path);
export const Post = (path: string) => RouterMethod('post', path);
export const Put = (path: string) => RouterMethod('put', path);
export const Delete = (path: string) => RouterMethod('delete', path);
export const Patch = (path: string) => RouterMethod('patch', path);
export const Options = (path: string) => RouterMethod('options', path);
export const Head = (path: string) => RouterMethod('head', path);
export const All = (path: string) => RouterMethod('all', path);
