import { Context } from '@satorijs/satori';
import { Registrar } from 'cordis-decorators';
import { selectContext, Selection } from './utility/select-context';

export class SatoriRegistrar<Ctx extends Context> extends Registrar<Ctx> {
  selectorDecorators() {
    return {
      OnAnywhere: () => this.decorateTransformer((ctx, r) => ctx.any()),
      OnNowhere: () => this.decorateTransformer((ctx, r) => ctx.never()),
      OnUser: (...values: string[]) =>
        this.decorateTransformer((ctx, r) => ctx.user(...r(values))),
      OnSelf: (...values: string[]) =>
        this.decorateTransformer((ctx, r) => ctx.self(...r(values))),
      OnGuild: (...values: string[]) =>
        this.decorateTransformer((ctx, r) => ctx.guild(...r(values))),
      OnChannel: (...values: string[]) =>
        this.decorateTransformer((ctx, r) => ctx.channel(...r(values))),
      OnPlatform: (...values: string[]) =>
        this.decorateTransformer((ctx, r) => ctx.platform(...r(values))),
      OnPrivate: (...values: string[]) =>
        this.decorateTransformer((ctx, r) => ctx.private(...r(values))),
      OnSelection: (selection: Selection) =>
        this.decorateTransformer((ctx, r) => selectContext(ctx, r(selection))),
    };
  }

  scopeDecorators() {
    return {
      ...super.scopeDecorators(),
      ...this.selectorDecorators(),
    };
  }
}

export const defaultRegistrarS = new SatoriRegistrar(Context);
