import { ConfigurableModuleBuilder, Inject, Module } from '@nestjs/common';
import { Aragami, AragamiOptions, MemoryDriver } from 'aragami';

const { ConfigurableModuleClass, MODULE_OPTIONS_TOKEN } =
  new ConfigurableModuleBuilder<AragamiOptions>()
    .setExtras(
      {
        isGlobal: true,
      },
      (definition, extras) => ({
        ...definition,
        global: extras.isGlobal,
      }),
    )
    .build();

export const ARAGAMI_TOKEN = 'ARAGAMI_TOKEN';
export const AGAGAMI_MEMORY_DRIVER_TOKEN = 'AGAGAMI_MEMORY_DRIVER_TOKEN';
export const InjectAragami = () => Inject(ARAGAMI_TOKEN);

@Module({
  providers: [
    {
      provide: ARAGAMI_TOKEN,
      useFactory: (options: AragamiOptions, memoryDriver: MemoryDriver) =>
        new Aragami({
          ...options,
          ...(!options.useDriver && !options.redis
            ? {
                useDriver: memoryDriver,
              }
            : {}),
        }),
      inject: [MODULE_OPTIONS_TOKEN, AGAGAMI_MEMORY_DRIVER_TOKEN],
    },
    {
      provide: AGAGAMI_MEMORY_DRIVER_TOKEN,
      useFactory: () => new MemoryDriver(),
    },
  ],
  exports: [ARAGAMI_TOKEN],
})
export class AragamiModule extends ConfigurableModuleClass {}

export * from './src/aragami-cache.interceptor';
export * from './src/queue-runner';
