import { Game, ReportScoreResult, Round } from '../index';

function checkRound(round: Round) {
  expect(round.matches.length).toBeGreaterThan(0);
  for (const match of round.matches) {
    expect(match.scores).toEqual([0, 0]);
    const [playerA, playerB] = match.players;
    expect(playerA.startsWith('a')).toBe(true);
    expect(playerB.startsWith('b')).toBe(true);
  }
}

function testRule(rule: string) {
  const game = new Game(
    '111111111',
    new Date('2022-02-23 13:00:00'),
    rule,
    'A',
    'B',
    ['a1', 'a2', 'a3'],
    ['b1', 'b2', 'b3'],
  );
  expect(game.rounds.length).toBe(1);
  checkRound(game.rounds[0]);
  console.log(game.format());

  expect(game.reportScore('a1', 2, 0)).toBe(ReportScoreResult.Continue);
  expect(game.reportScore('a2', 0, 2)).toBe(ReportScoreResult.Continue);
  expect(game.reportScore('a3', 2, 1)).toBe(
    rule === '人头赛' ? ReportScoreResult.Finish : ReportScoreResult.NextRound,
  );
  console.log(game.format());

  if (rule === '人头赛') {
    return;
  }

  expect(game.rounds.length).toBe(2);
  checkRound(game.rounds[1]);
  console.log(game.format());
}

describe('Tabulator.', () => {
  it('should tabulate on head game', () => {
    testRule('人头赛');
  });
  it('should tabulate on KOF game', () => {
    testRule('2/3【KOF】');
  });
});
