import { Session } from 'koishi';
import { SendTarget } from '..';

describe('Target def.', () => {
  const def = new SendTarget({
    bot: 'onebot:123456789',
    users: ['1111111111'],
    channels: [{ channelId: '1111111111' }],
  });
  const filter = def.getFilter();
  it('should detect platform', () => {
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        userId: '1111111111',
      } as Session),
    ).toBe(true);
    expect(
      filter({
        platform: 'onebot1',
        selfId: '123456789',
        userId: '1111111111',
      } as Session),
    ).toBe(false);
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456782',
        userId: '1111111111',
      } as Session),
    ).toBe(false);
  });

  it('should detect private', () => {
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        userId: '1111111111',
      } as Session),
    ).toBe(true);
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        userId: '1111111112',
      } as Session),
    ).toBe(false);
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        userId: '1111111111',
        guildId: '111',
      } as Session),
    ).toBe(false);
  });

  it('should detect channel', () => {
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        channelId: '1111111111',
      } as Session),
    ).toBe(true);
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        channelId: '1111111112',
      } as Session),
    ).toBe(false);
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        channelId: '1111111111',
        guildId: '1111111112',
      } as Session),
    ).toBe(true);
  });
});
