import { segment, Session } from 'koishi';
import { SendTarget } from '../index';

describe('Target def.', () => {
  const def = new SendTarget({
    bot: 'onebot:123456789',
    users: ['1111111111'],
    channels: [{ channelId: '1111111111' }],
  });
  const filter = def.getFilter();
  it('should detect platform', () => {
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        userId: '1111111111',
      } as Session),
    ).toBe(true);
    expect(
      filter({
        platform: 'onebot1',
        selfId: '123456789',
        userId: '1111111111',
      } as Session),
    ).toBe(false);
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456782',
        userId: '1111111111',
      } as Session),
    ).toBe(false);
  });

  it('should detect private', () => {
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        userId: '1111111111',
      } as Session),
    ).toBe(true);
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        userId: '1111111112',
      } as Session),
    ).toBe(false);
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        userId: '1111111111',
        guildId: '111',
      } as Session),
    ).toBe(false);
  });

  it('should detect channel', () => {
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        channelId: '1111111111',
      } as Session),
    ).toBe(true);
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        channelId: '1111111112',
      } as Session),
    ).toBe(false);
    expect(
      filter({
        platform: 'onebot',
        selfId: '123456789',
        channelId: '1111111111',
        guildId: '1111111112',
      } as Session),
    ).toBe(true);
  });

  it('should replace content', () => {
    const target = new SendTarget({});
    const imageBase64 = segment('image', { url: 'base64://foo' });
    const imageBase64Replaced = segment.parse(
      target.replaceContent(imageBase64.toString(), 'url', 'url'),
    )[0];
    const imageUrl = segment('image', {
      file: 'http://example.com/1.png',
    });
    const imageUrlReplaced = segment.parse(
      target.replaceContent(imageUrl.toString(), 'file', 'url'),
    )[0];
    expect(imageBase64Replaced.attrs?.url).toBeUndefined();
    expect(imageBase64Replaced.attrs?.file).toBe('base64://foo');
    expect(imageUrlReplaced.attrs?.url).toBe('http://example.com/1.png');
    expect(imageUrlReplaced.attrs?.file).toBeUndefined();
  });
});
