// import 'source-map-support/register';
import { SchedulePluginConfig } from './config';
import {
  BasePlugin,
  CreatePluginFactory,
  Inject,
  InjectLogger,
} from 'koishi-thirdeye';
import { Logger } from 'koishi';
import { Adapter } from 'koishi';
import { Bot } from 'koishi';
export * from './config';

export class BaseSchedulePlugin extends BasePlugin<SchedulePluginConfig> {
  @InjectLogger()
  logger: Logger;

  @Inject(true)
  bots: Adapter.BotList;

  async send() {
    return '';
  }

  async processSend() {
    let message: string;
    this.logger.info(`Running schedule task...`);
    try {
      message = await this.send();
    } catch (e) {
      this.logger.error(`Errored when running schedule task: ${e.message}`);
      return;
    }
    if (!message) {
      this.logger.warn(`Skipped schedule task for empty content.`);
      return;
    }
    await Promise.all(
      this.config.targets.map(async (target) => {
        try {
          const bot = this.bots.get(target.bot);
          this.logger.debug(`Sending message from ${target.bot}.`);
          const ids = await target.send(this.bots, message);
          this.logger.debug(
            `Message sent from ${target.bot}: ${ids?.join(',')}`,
          );
        } catch (e) {
          this.logger.error(
            `Failed to send message from ${target.bot}: ${e.toString()}`,
          );
        }
      }),
    );
  }

  async onConnect() {
    this.config.initializeTasks(this.ctx, () => this.processSend());
  }
}

export const SchedulePlugin = CreatePluginFactory(
  BaseSchedulePlugin,
  SchedulePluginConfig,
);
