import { Context } from 'koishi';
import {
  DefinePlugin,
  MultiInstancePlugin,
  SchemaProperty,
} from 'koishi-thirdeye';
import { SchedulePlugin } from '../src';

class Config {
  @SchemaProperty()
  message: string;
}

@DefinePlugin()
class TestSendPlugin extends SchedulePlugin(Config) {
  async send() {
    return this.config.message;
  }
}

@DefinePlugin()
class MultiTestSendPlugin extends MultiInstancePlugin(TestSendPlugin) {}

export default class ExtrasInDev {
  constructor(ctx: Context) {
    ctx.plugin(MultiTestSendPlugin, {
      instances: [
        {
          message: 'dress',
          randomInterval: { max: 10000, min: 5000 },
          immediate: true,
          targets: [
            {
              bot: 'sandbox:koishi',
              users: ['Alice', 'Bob'],
              channels: [{ channelId: '#' }],
            },
          ],
        },
      ],
    });
  }
}
