# koishi-schedule-send

编写自动发送消息的 Koishi 插件框架。

## 编写插件

```ts
export class Config {
  @SchemaProperty()
  message: string;
}

// 在这里不用写任何东西
@DefinePlugin()
export default class TestSendPlugin extends SchedulePlugin(Config) {
  async send() {
    return this.config.message;
  }
}
```

### 配置

配置会自动从插件工厂函数中混入，下面为配置。其中 `targets` 见 [koishi-target-def](https://www.npmjs.com/package/koishi-target-def) 的定义。

```yaml
cron: '18 13 * * * *'
interval: 30000 # cron 和 interval 选一个即可
immediate: false # 是否立即发送
targets:
  - bot: 'onebot:1111111111'
    channels:
      - channelId: '222222222'
```
