# koishi-schedule-send

编写自动发送消息的 Koishi 插件框架。

## 编写插件

```ts
export class Config {
  @SchemaProperty()
  message: string;
}

// 在这里不用写任何东西
@DefinePlugin()
export default class TestSendPlugin extends SchedulePlugin(Config) {
  async send() {
    return this.config.message;
  }
}
```

### 配置

配置会自动从插件工厂函数中混入。

```ts
export class SchedulePluginConfig {
  @SchemaProperty({ description: 'cron 时间' })
  cron: string;

  @SchemaProperty({ description: '执行的间隔 ms', step: 1 })
  interval: number;

  @SchemaProperty({
    default: false,
    description: '插件启动时是否立即运行一遍。',
  })
  immediate: boolean;

  @SchemaProperty({
    type: SendTarget,
    description: '图片发送目标。',
  })
  targets: SendTarget[];
}
```
