// import 'source-map-support/register';
import { Context } from 'koishi';
import { SendTarget } from 'koishi-target-def';
import { SchemaProperty } from 'koishi-thirdeye';
import { scheduleJob } from 'node-schedule';

export class SchedulePluginConfig {
  @SchemaProperty({ description: 'cron 时间' })
  cron: string;

  @SchemaProperty({ description: '执行的间隔 ms', step: 1 })
  interval: number;

  @SchemaProperty({
    default: false,
    description: '插件启动时是否立即运行一遍。',
  })
  immediate: boolean;

  @SchemaProperty({
    type: SendTarget,
    description: '图片发送目标。',
  })
  targets: SendTarget[];

  initializeTasks(ctx: Context, callback: () => void) {
    if (this.immediate) {
      callback();
    }
    if (this.cron) {
      const job = scheduleJob(this.cron, callback);
      ctx.on('dispose', () => {
        job.cancel()
      });
    }
    if (this.interval) {
      ctx.setInterval(callback, this.interval);
    }
  }
}
