// import 'source-map-support/register';
import { SchedulePluginConfig } from './config';
import {
  BasePlugin,
  ClassType,
  Inject,
  InjectLogger,
  Mixin,
  PluginSchema,
} from 'koishi-thirdeye';
import { Logger } from 'koishi';
import { Adapter } from 'koishi';
import { Bot } from 'koishi';
export * from './config';

export class BaseSchedulePlugin<C> extends BasePlugin<
  SchedulePluginConfig & C
> {
  @InjectLogger()
  logger: Logger;

  @Inject(true)
  bots: Adapter.BotList;

  async send() {
    return '';
  }

  isOneBotBot(bot?: Bot) {
    return (
      bot &&
      (bot.platform === 'onebot' || bot['parentBot']?.platform === 'onebot')
    );
  }

  async processSend() {
    let message: string;
    this.logger.info(`Running schedule task...`);
    try {
      message = await this.send();
    } catch (e) {
      this.logger.error(`Errored when running schedule task: ${e.message}`);
      return;
    }
    if (!message) {
      this.logger.warn(`Skipped schedule task for empty content.`);
      return;
    }
    await Promise.all(
      this.config.targets.map(async (target) => {
        try {
          let targetMessage = message;
          const bot = this.bots.get(target.bot);
          if (this.isOneBotBot(bot)) {
            targetMessage = message.replace(/,url=base64/g, ',file=base64');
          }
          this.logger.debug(`Sending message from ${target.bot}.`);
          const ids = await target.send(this.bots, targetMessage);
          this.logger.debug(
            `Message sent from ${target.bot}: ${ids?.join(',')}`,
          );
        } catch (e) {
          this.logger.error(
            `Failed to send message from ${target.bot}: ${e.toString()}`,
          );
        }
      }),
    );
  }

  async onConnect() {
    this.config.initializeTasks(this.ctx, () => this.processSend());
  }
}

export function SchedulePlugin<C>(config?: ClassType<C>) {
  const plugin = class SpecificSchedulePlugin extends BaseSchedulePlugin<C> {};
  PluginSchema(Mixin(config, SchedulePluginConfig))(plugin);
  return plugin;
}
