import { Context } from 'koishi';
import { DefinePlugin, SchemaProperty } from 'koishi-thirdeye';
import { SchedulePlugin } from '../src';

class Config {
  @SchemaProperty()
  message: string;
}

@DefinePlugin()
class TestSendPlugin extends SchedulePlugin(Config) {
  async send() {
    return this.config.message;
  }
}

export default class ExtrasInDev {
  constructor(ctx: Context) {
    ctx.plugin(TestSendPlugin, {
      message: 'dress',
      interval: 5000,
      immediate: true,
      targets: [
        {
          bot: 'sandbox:koishi',
          users: ['Alice', 'Bob'],
          channels: [{ channelId: '#' }],
        },
      ],
    });
  }
}
