import { Type } from 'class-transformer';

export class Status {
  score: number;
  lp: number;
  cards: number;
}

export class User {
  id: string;
  name: string;
  ip?: string;
  @Type(() => Status)
  status?: Status;
  pos: number;
  isPlayer() {
    return this.pos < 4;
  }
  getRealName() {
    return this.name?.split('$')[0];
  }
}

export class Room {
  roomid: string;
  roomname: string;
  roommode: number;
  needpass: string;
  @Type(() => User)
  users: User[];
  istart: string;
  includesUser(name: string) {
    return this.users.find((u) => u.isPlayer() && u.getRealName() === name);
  }
}

export class SRVProRoomInfo {
  @Type(() => Room)
  rooms: Room[];
  searchForUser(name: string) {
    return this.rooms.filter((r) => r.includesUser(name));
  }
}
