const path = require('path');

const packAll = !!process.env.PACK_ALL;

module.exports = {
  entry: './src/index.ts',
  mode: 'production',
  target: 'node',
  devtool: 'source-map',
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/,
      },
      { test: /\.mustache$/, use: 'raw-loader' },
    ],
  },
  resolve: {
    extensions: ['.tsx', '.ts', '.js'],
  },
  output: {
    filename: 'index.js',
    library: {
      type: 'commonjs',
    },
    path: path.resolve(__dirname, packAll ? 'dist/full' : 'dist'),
  },
  externals: {
    koishi: 'koishi',
    'proxy-agent': 'proxy-agent',
    axios: 'axios',
    ...(packAll
      ? {}
      : {
          '@aws-sdk/client-s3': '@aws-sdk/client-s3',
          '@aws-sdk/middleware-sdk-s3': '@aws-sdk/middleware-sdk-s3',
          '@aws-sdk/protocol-http': '@aws-sdk/protocol-http',
          '@aws-sdk/smithy-client': '@aws-sdk/smithy-client',
          '@aws-sdk/util-format-url': '@aws-sdk/util-format-url',
          '@aws-sdk/types': '@aws-sdk/types',
          'koishi-utils-schemagen': 'koishi-utils-schemagen',
          'class-transformer': 'class-transformer',
          moment: 'moment',
        }),
  },
};
