import { DefineSchema, RegisterSchema } from 'schemastery-gen';
import { Schema } from 'koishi';
import { YGOProCardLike } from './YGOProCard';
import _ from 'lodash';
import { renderTemplate } from './utility';

@RegisterSchema()
export class YGOCardConfig {
  @DefineSchema({ type: 'string', description: '命令名', default: 'card' })
  commandName: string;

  @DefineSchema({
    type: 'string',
    array: true,
    default: ['./cdb'],
    description: '数据库文件的路径',
  })
  databasePaths: string[];

  @DefineSchema({ type: 'number', default: 100, description: '查询最多显示的数量' })
  matchCount: number;

  @DefineSchema({
    type: Schema.union(['cn', 'en']).description('显示语言').default('cn'),
  })
  lang: 'cn' | 'en';

  @DefineSchema({ type: 'boolean', description: '是否展示卡图', default: true })
  displayPic: boolean;

  @DefineSchema({
    type: 'string',
    description: '卡图源，将 {{id}} 替换为卡号',
    default:
      'https://cdn02.moecube.com:444/images/ygopro-images-zh-CN/{{id}}.jpg',
  })
  picUrl: string;

  renderUrl(obj: Partial<YGOProCardLike>) {
    return renderTemplate(
      this.picUrl,
      _.mapValues(obj, (s) => encodeURIComponent(s)),
    );
  }
}
