export class CardInfoService {
  private cardInfo = {
    cn: {
      '1010': '地',
      '1011': '水',
      '1012': '炎',
      '1013': '风',
      '1014': '光',
      '1015': '暗',
      '1016': '神',
      '1020': '战士',
      '1021': '魔法师',
      '1022': '天使',
      '1023': '恶魔',
      '1024': '不死',
      '1025': '机械',
      '1026': '水',
      '1027': '炎',
      '1028': '岩石',
      '1029': '鸟兽',
      '1030': '植物',
      '1031': '昆虫',
      '1032': '雷',
      '1033': '龙',
      '1034': '兽',
      '1035': '兽战士',
      '1036': '恐龙',
      '1037': '鱼',
      '1038': '海龙',
      '1039': '爬虫',
      '1040': '念动力',
      '1041': '幻神兽',
      '1042': '创造神',
      '1043': '幻龙',
      '1044': '电子界',
      '1050': '怪兽',
      '1051': '魔法',
      '1052': '陷阱',
      '1053': '？？？',
      '1054': '通常',
      '1055': '效果',
      '1056': '融合',
      '1057': '仪式',
      '1058': '陷阱怪兽',
      '1059': '灵魂',
      '1060': '同盟',
      '1061': '二重',
      '1062': '调整',
      '1063': '同调',
      '1064': '衍生物',
      '1065': '？？？',
      '1066': '速攻',
      '1067': '永续',
      '1068': '装备',
      '1069': '场地',
      '1070': '反击',
      '1071': '反转',
      '1072': '卡通',
      '1073': '超量',
      '1074': '灵摆',
      '1075': '特殊召唤',
      '1076': '连接',
    },
    en: {
      '1010': 'EARTH',
      '1011': 'WATER',
      '1012': 'FIRE',
      '1013': 'WIND',
      '1014': 'LIGHT',
      '1015': 'DARK',
      '1016': 'DIVINE',
      '1020': 'Warrior',
      '1021': 'Spellcaster',
      '1022': 'Fairy',
      '1023': 'Fiend',
      '1024': 'Zombie',
      '1025': 'Machine',
      '1026': 'Aqua',
      '1027': 'Pyro',
      '1028': 'Rock',
      '1029': 'Winged Beast',
      '1030': 'Plant',
      '1031': 'Insect',
      '1032': 'Thunder',
      '1033': 'Dragon',
      '1034': 'Beast',
      '1035': 'Beast-Warrior',
      '1036': 'Dinosaur',
      '1037': 'Fish',
      '1038': 'Sea Serpent',
      '1039': 'Reptile',
      '1040': 'Psychic',
      '1041': 'Divine-Beast',
      '1042': 'Creator God',
      '1043': 'Wyrm',
      '1044': 'Cyberse',
      '1050': 'Monster',
      '1051': 'Spell',
      '1052': 'Trap',
      '1053': '???',
      '1054': 'Normal',
      '1055': 'Effect',
      '1056': 'Fusion',
      '1057': 'Ritual',
      '1058': 'Trap Monster',
      '1059': 'Spirit',
      '1060': 'Union',
      '1061': 'Gemini',
      '1062': 'Tuner',
      '1063': 'Synchro',
      '1064': 'Token',
      '1065': '???',
      '1066': 'Quick-Play',
      '1067': 'Continuous',
      '1068': 'Equip',
      '1069': 'Field',
      '1070': 'Counter',
      '1071': 'Flip',
      '1072': 'Toon',
      '1073': 'Xyz',
      '1074': 'Pendulum',
      '1075': 'Special Summon',
      '1076': 'Link',
    },
  };
  getStringValueByMysticalNumber(
    lang: 'cn' | 'en',
    offset: number,
    num: number,
  ): string {
    const results: string[] = [];
    for (let i = 0; i < 32; i++) {
      if (num & (1 << i)) {
        const index = offset + i;
        const key = index.toString();
        results.push(this.cardInfo[lang][key] || index);
      }
    }
    return results.join('|');
  }
}
