import { DefineSchema, UseSchema } from 'koishi-utils-schemagen';
import { Schema } from 'koishi';
import { YGOProCardLike } from './YGOProCard';
import _ from 'lodash';
import { renderTemplate } from './utility';

export class YGOCardConfig {
  @DefineSchema({ type: 'string', desc: '命令名', default: 'card' })
  commandName: string;

  @DefineSchema({
    type: 'string',
    array: true,
    default: ['./cdb'],
    desc: '数据库文件的路径',
  })
  databasePaths: string[];

  @DefineSchema({ type: 'number', default: 100, desc: '查询最多显示的数量' })
  matchCount: number;

  @UseSchema(Schema.select(['cn', 'en'], '显示语言').default('cn'))
  lang: 'cn' | 'en';

  @DefineSchema({ type: 'boolean', desc: '是否展示卡图', default: true })
  displayPic: boolean;

  @DefineSchema({
    type: 'string',
    desc: '卡图源，将 {{id}} 替换为卡号',
    default:
      'https://cdn02.moecube.com:444/images/ygopro-images-zh-CN/{{id}}.jpg',
  })
  picUrl: string;

  renderUrl(obj: Partial<YGOProCardLike>) {
    return renderTemplate(
      this.picUrl,
      _.mapValues(obj, (s) => encodeURIComponent(s)),
    );
  }
}
