// import 'source-map-support/register';
import { XffPluginConfig } from './config';
import {
  DefinePlugin,
  BasePlugin,
  LifecycleEvents,
  Inject,
} from 'koishi-thirdeye';
export * from './config';
import { Router } from 'koishi';

@DefinePlugin({ name: 'xff', schema: XffPluginConfig })
export default class XffPlugin
  extends BasePlugin<XffPluginConfig>
  implements LifecycleEvents
{
  @Inject(true)
  private router: Router;

  onApply() {
    this.router.use(this.config.getMiddleware());
    const { stack } = this.router;
    const xffStack = stack.pop();
    stack.unshift(xffStack);
  }
}
