// import 'source-map-support/register';
import koaTrustProxy from 'koa-trust-proxy';
import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class XffPluginConfig {
  constructor(config: XffPluginConfigLike) {}

  @SchemaProperty({ description: '代理头名称。', default: 'x-forwarded-for' })
  header: string;

  @SchemaProperty({
    description: '可信任的代理服务器',
    type: String,
    default: ['loopback', '172.16.0.0/12'],
  })
  trustedProxies: string[];

  getMiddleware() {
    return koaTrustProxy(this.trustedProxies, this.header);
  }
}

export type XffPluginConfigLike = Partial<XffPluginConfig>;
