import { Context } from 'koishi';
import TargetPlugin from '../src';
import request from 'supertest';

describe('Test of plugin.', () => {
  let app: Context;

  beforeEach(async () => {
    app = new Context();
    app.plugin(TargetPlugin);
    await app.start();
  });

  it('should recognize xff', () => {
    app.router.get('/ip', (ctx) => {
      ctx.status = 200;
      ctx.body = ctx.ip;
    });
    return request(app.router._http)
      .get('/ip')
      .set('x-forwarded-for', '1.1.1.1,11.4.51.4')
      .expect(200)
      .expect('11.4.51.4');
  });
});
