import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class WhoViewsPluginConfig {
  constructor(config: WhoViewsPluginConfigLike) {}

  @SchemaProperty({
    type: 'string',
    description:
      'qqwry IP 地址库路径。在 https://github.com/out0fmemory/qqwry.dat 可以获取。',
    required: true,
  })
  qqwryPath: string;

  @SchemaProperty({
    type: String,
    description: '图片标签。见 koishi-plugin-pics 文档。',
  })
  tags: string[];

  @SchemaProperty({
    type: String,
    description: '图源标签。见 koishi-plugin-pics 文档。',
  })
  sourceTags: string[];

  @SchemaProperty({ description: '图片接口路径。', default: '/who' })
  path: string;

  @SchemaProperty({
    description: 'Koishi 在公网暴露的地址。也可以在 Koishi 根配置指定。',
  })
  selfUrl: string;

  @SchemaProperty({
    description: '等待接受数据的时间，单位秒。',
    default: 5,
  })
  waitTime: number;
}

export type WhoViewsPluginConfigLike = Partial<WhoViewsPluginConfig>;
