# koishi-plugin-typeorm

如果不喜欢 Koishi 的数据库设计的话，来用这个也是一个选择。

本插件提供了 TypeORM 的服务，可以用 `ctx.typeorm` 进行访问。

本插件**不是** Koishi 数据库支持。

## 安装

```bash
npm install koishi-plugin-typeorm
```

## 使用

### 配置

详见 [TypeORM 连接参数](https://github.com/typeorm/typeorm/blob/master/docs/connection-options.md) 。

只需要配置 `type` 以及 `host` `port` `usertoken` `password` 等连接参数即可。 `entities` 不在此处进行配置。

### 使用

每一个 Koishi 插件可以使用本插件提供的服务，使用 `create` 方法创建数据库连接，并在插件中使用。

每个连接的实体是独立的，不可以跨数据库连接建立关系。

#### 示例

```ts
export const using = ['typeorm']
export function apply(ctx: Context, config: any) {
  ctx.on('ready', async () => {
    await ctx.typeorm.create('myplugin', [MyEntity]);
  });
  
  ctx.command('foo')
    .action(async(argv, id) => {
      const repo = ctx.typeorm.getRepository(MyEntity);
      const data = await repo.fineOne(id);
    });
}
```

### API

- `create(token: string, entities: TypeORMEntity[], extraOptions?: ConnectionOptions): Promise<Connection>` 注册一个数据库连接。
    - `token` 数据库连接名称。
    - `entities` 数据库实体。
    - `extraOptions` 额外的连接参数。

该方法同时会在插件关闭时自动关闭数据库连接。

- `getConnection(token: string): Connection` 获取一个数据库连接。

- `getEntityManager(token: string): EntityManager` 获取一个实体管理器。

- `getRepository<T>(entity: TypeORMEntity<T>): Repository<T>` 获取一个数据库实体的仓库。

- `close(token: string): Promise<void>` 关闭一个数据库连接。
