import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';
import { ConnectionOptions, EntitySchema } from 'typeorm';
import { PostgresConnectionOptions } from 'typeorm/driver/postgres/PostgresConnectionOptions';

export type TypeORMPluginConfigLike = ConnectionOptions;

@RegisterSchema()
export class TypeORMPluginConfig implements PostgresConnectionOptions {
  constructor(config: TypeORMPluginConfigLike) {}

  @DefineSchema({
    description: '数据库类型',
    default: 'postgres',
    type: String,
  })
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  // @ts-ignore
  type:
    | 'postgres'
    | 'mysql'
    | 'mariadb'
    | 'cockroachdb'
    | 'sqlite'
    | 'mssql'
    | 'sap'
    | 'oracle'
    | 'cordova'
    | 'nativescript'
    | 'react-native'
    | 'sqljs'
    | 'mongodb'
    | 'aurora-data-api'
    | 'aurora-data-api-pg'
    | 'expo'
    | 'better-sqlite3'
    | 'capacitor';

  @DefineSchema({ description: '数据库地址。' })
  host: string;

  @DefineSchema({ description: '数据库端口。' })
  port: number;

  @DefineSchema({ description: '数据库名称。' })
  database: string;

  @DefineSchema({ description: '数据库用户名。' })
  username: string;

  @DefineSchema({ description: '数据库密码。' })
  password: string;

  @DefineSchema({ description: '是否自动建表。', default: true })
  synchronize: boolean;
}

// eslint-disable-next-line @typescript-eslint/ban-types
export type TypeORMEntity<T = any> =
  | { new (...args: any[]): T }
  | EntitySchema<T>;
