import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class ThesaurusPluginConfig {
  constructor(config: Partial<ThesaurusPluginConfig>) {}
  @DefineSchema({
    description: '词库本地路径或 URL。',
    default:
      'https://code.mycard.moe/3rdeye/AnimeThesaurus/-/raw/main/data.json',
  })
  path: string;

  @DefineSchema({
    description: '聊天超时时间 ms。',
    default: 600000,
    role: 'ms',
  })
  chatTimeout: number;

  @DefineSchema({
    description: '追溯会话长度',
    default: 10,
  })
  trackingLength: number;
}

export type ThesaurusPluginConfigLike = Partial<ThesaurusPluginConfig>;
