import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'schemastery-gen';

@RegisterSchema()
export class MyPluginConfig {
  constructor(config: Partial<MyPluginConfig>) {}
  @DefineSchema({
    description: '词库本地路径或 URL。',
    default:
      'https://code.mycard.moe/3rdeye/AnimeThesaurus/-/raw/main/data.json',
  })
  path: string;

  @DefineSchema({
    description: '聊天超时时间 ms。',
    default: 600000,
    role: 'ms',
  })
  chatTimeout: number;

  @DefineSchema({
    description: '追溯会话长度',
    default: 10,
  })
  trackingLength: number;

  @DefineSchema({
    description: '从数据库获取用户名。',
    default: false,
  })
  useDatabase: boolean;
}

export type MyPluginConfigLike = Partial<MyPluginConfig>;
