import 'source-map-support/register';
import { DefineSchema } from 'koishi-utils-schemagen';

export class MyPluginConfig {
  @DefineSchema({
    desc: '词库本地路径或 URL。',
    default:
      'https://code.mycard.moe/3rdeye/AnimeThesaurus/-/raw/main/data.json',
  })
  path: string;

  @DefineSchema({
    desc: '聊天超时时间 ms。',
    default: 600000,
  })
  chatTimeout: number;

  @DefineSchema({
    desc: '追溯会话长度',
    default: 10,
  })
  trackingLength: number;

  @DefineSchema({
    desc: '从数据库获取用户名。',
    default: false,
  })
  useDatabase: boolean;
}

export type MyPluginConfigLike = Partial<MyPluginConfig>;
