const path = require('path');

const packAll = !!process.env.PACK_ALL;

module.exports = {
  entry: './src/index.ts',
  mode: 'production',
  target: 'node',
  devtool: 'source-map',
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/,
      },
      { test: /\.mustache$/, use: 'raw-loader' },
    ],
  },
  resolve: {
    extensions: ['.tsx', '.ts', '.js'],
  },
  output: {
    filename: 'index.js',
    library: {
      type: 'commonjs',
    },
    path: path.resolve(__dirname, packAll ? 'dist/full' : 'dist'),
  },
  externals: {
    koishi: 'koishi',
    ...(packAll
      ? {}
      : {
          'koishi-thirdeye': 'koishi-thirdeye',
          'class-transformer': 'class-transformer',
          moment: 'moment',
          lodash: 'lodash',
        }),
  },
};
