// import 'source-map-support/register';
import { Context } from 'koishi';
import { MyPluginConfig } from './config';

export class MyPlugin {
  private config: MyPluginConfig;
  private ctx: Context;
  name = 'srvpro-roomlist-main';
  Config = MyPluginConfig as any;
  apply(ctx: Context, config: MyPluginConfig) {
    this.ctx = ctx;
    this.config = config;
    ctx
      .command(`${this.config.listCommandName}`, '获取服务器列表')
      .action(
        () =>
          `可以查询的服务器有:\n${this.config.servers
            .map(
              (s) => `${s.name}${s.tags.length ? `\t${s.tags.join(',')}` : ''}`,
            )
            .join('\n')}\n使用服务器名或标签即可查询对应服务器的房间列表。`,
      );
    ctx
      .command(
        `${this.config.roomCommandName} [serverName:string]`,
        '获取房间列表',
      )
      .usage(`可以查询的服务器请使用命令 ${this.config.listCommandName} 获取。`)
      .action((argv, serverName) => {
        const server = this.config.getServer(serverName);
        if (!server) {
          return `未找到服务器 ${serverName} 。`;
        }
        return server.getRoomString(ctx);
      });
  }
}
