import { Type } from 'class-transformer';
import { Server } from './config';
import _ from 'lodash';

export class Status {
  score: number;
  lp: number;
  cards: number;
  stringify(mode: number) {
    if (mode === 2) {
      return `(LP: ${this.lp})`;
    } else if (mode === 0) {
      return `(LP: ${this.lp} 卡数: ${this.cards})`;
    } else {
      return `(比分: ${this.score} LP: ${this.lp} 卡数: ${this.cards})`;
    }
  }
}

export class User {
  id: string;
  name: string;
  ip?: string;
  @Type(() => Status)
  status?: Status;
  pos: number;
  stringify(server: Server, room: Room) {
    let ret = this.name;
    if (this.ip && server.displayPlayerIp) {
      ret += ` (IP: ${this.ip})`;
    }
    if (this.status) {
      ret += ` ${this.status.stringify(room.roommode)}`;
    }
    return ret;
  }
}

export class Room {
  roomid: string;
  roomname: string;
  roommode: number;
  needpass: string;
  @Type(() => User)
  users: User[];
  istart: string;
  stringify(server: Server) {
    const userInPos: Record<number, User> = _.mapValues(
      _.groupBy(this.users, (u) => u.pos),
      (g) => g[0],
    );
    let usersString: string;
    if (this.roommode === 2) {
      usersString = `${userInPos[0]?.stringify(server, this) || '???'} & ${
        userInPos[1]?.stringify(server, this) || '???'
      } VS ${userInPos[2]?.stringify(server, this) || '???'} & ${
        userInPos[3]?.stringify(server, this) || '???'
      }`;
    } else {
      usersString = `${userInPos[0]?.stringify(server, this) || '???'} VS ${
        userInPos[1]?.stringify(server, this) || '???'
      }`;
    }
    return `${this.roomname.split('$')[0]}${
      this.needpass === 'false' ? '' : ` (LOCK)`
    }\t${usersString}\t${this.istart}`;
  }
}

export class SRVProRoomInfo {
  @Type(() => Room)
  rooms: Room[];
  stringify(server: Server) {
    let rooms = this.rooms;
    if (!server.displayPrivateRooms) {
      rooms = rooms.filter((r) => r.needpass === 'false');
    }
    return `${server.name} 的房间列表\n--------------------\n${rooms
      .map((r) => r.stringify(server))
      .join('\n')}\n--------------------\n共有 ${rooms.length} 个房间`;
  }
}
