import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';
import fs from 'fs';
import { Random } from 'koishi';

@RegisterSchema()
export class SpammerConfig {
  constructor(config: SpammerConfigLike) {}

  @SchemaProperty({ type: String, description: '文本文件路径。' })
  paths: string[];

  @SchemaProperty({
    type: String,
    description: '文本文件编码。',
    default: 'utf8',
  })
  encoding: BufferEncoding;

  @SchemaProperty({ type: String, description: '预设文本。' })
  presets: string[];

  private async readLines(path: string) {
    const content = await fs.promises.readFile(path, this.encoding);
    return content
      .trim()
      .split(/\r?\n/)
      .filter((line) => !!line);
  }

  async getText() {
    const paths = Array.from(this.paths);
    if (this.presets.length) {
      paths.push('___presets___');
    }
    const path = Random.pick(paths);
    if (path === '___presets___') {
      return Random.pick(this.presets);
    }
    const lines = await this.readLines(path);
    return Random.pick(lines);
  }
}

export type SpammerConfigLike = Partial<SpammerConfig>;
