import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class ShadowbanPluginConfig {
  constructor(config: Partial<ShadowbanPluginConfig>) {}
  @DefineSchema({
    description: 'Shadowban API 地址。',
    default: 'https://sbapi.lv5.ac:444',
    role: 'url',
  })
  endpoint: string;

  getUrlForUsername(username: string) {
    return `${this.endpoint}/${username}`;
  }
}

export type ShadowbanPluginConfigLike = Partial<ShadowbanPluginConfig>;
