import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';
import { NodeOptions } from '@sentry/node';

@RegisterSchema()
export class SentryPluginConfig implements NodeOptions {
  constructor(config: SentryPluginConfigLike) {}

  @DefineSchema({ description: 'Sentry DSN. ', role: 'url' })
  dsn: string;

  @DefineSchema({ description: '以 Breadcrumb 记录日志。', default: false })
  logAsBreadcrumb?: boolean;
}

export type SentryPluginConfigLike = Partial<SentryPluginConfig>;
