// import 'source-map-support/register';
import { SentryPluginConfig } from './config';
import { DefinePlugin, StarterPlugin, LifecycleEvents } from 'koishi-thirdeye';
import * as Sentry from '@sentry/node';
import { Logger, remove } from 'koishi';
export * from './config';

@DefinePlugin({ name: 'myplugin', schema: SentryPluginConfig })
export default class SentryPlugin
  extends StarterPlugin(SentryPluginConfig)
  implements LifecycleEvents
{
  onApply() {
    Sentry.init(this.config);
    Logger.targets.push(this.target);
  }

  onDisconnect() {
    remove(Logger.targets, this.target);
  }

  private getLogModeFromHeader(header: string) {
    switch (header) {
      case '[S] ':
        return Sentry.Severity.Log;
      case '[I] ':
        return Sentry.Severity.Info;
      case '[W] ':
        return Sentry.Severity.Warning;
      case '[E] ':
        return Sentry.Severity.Error;
      case '[D] ':
        return Sentry.Severity.Debug;
      default:
        return Sentry.Severity.Info;
    }
  }

  private target: Logger.Target = {
    colors: 0,
    showTime: undefined,
    showDiff: undefined,
    print: (text) => {
      const header = text.slice(0, 4);
      const body = text.slice(4);
      const mode = this.getLogModeFromHeader(header);
      if (this.config.logAsBreadcrumb) {
        const bodySplit = body.split(' ');
        const context = bodySplit.length > 1 ? bodySplit[0] : 'default';
        const message =
          bodySplit.length > 1 ? bodySplit.slice(1).join(' ') : body;
        Sentry.addBreadcrumb({
          message,
          level: mode,
          data: {
            context,
          },
        });
      } else {
        Sentry.captureMessage(body, { level: mode });
      }
    },
  };
}
