import { App } from 'koishi';
import TargetPlugin from '../src';
import ConsolePlugin from '@koishijs/plugin-console';
import SandboxPlugin from '@koishijs/plugin-sandbox';
import DatabasePlugin from '@koishijs/plugin-database-memory';
import CachePlugin from '@koishijs/plugin-cache-lru';
import ExtrasInDev from './extras';

const app = new App({
  port: 14514,
  host: 'localhost',
  prefix: '.',
});

// Console and sandbox
app.plugin(SandboxPlugin);
app.plugin(ConsolePlugin, {
  open: false,
});

// Some services
app.plugin(CachePlugin);
app.plugin(DatabasePlugin);

// Some extras
app.plugin(ExtrasInDev);

// Target plugin
app.plugin(TargetPlugin, {
  dsn: 'https://83e91da3bb384d42b1dbb78ac266d698@sentry.momobako.com/2',
  logAsBreadcrumb: false,
});

declare module 'koishi' {
  interface User {
    dress: { name: string };
  }
}

const logger = app.logger('sentry-dev');
for (const level of ['error', 'warn', 'info', 'debug', 'success'] as const) {
  app
    .command(`${level} <content:text>`, `创建 ${level} 日志`)
    .userFields(['name', 'dress.name'])
    .action((argv, content) => {
      logger[level](content);
    });
}

app.start();
