import { App } from 'koishi';
import TargetPlugin from '../src';
import ConsolePlugin from '@koishijs/plugin-console';
import * as SandboxPlugin from '@koishijs/plugin-sandbox';
import DatabasePlugin from '@koishijs/plugin-database-memory';
import * as Help from '@koishijs/plugin-help';
import ExtrasInDev from './extras';

const app = new App({
  port: 14514,
  host: 'localhost',
  prefix: '.',
});

app.plugin(Help);

// Console and sandbox
app.plugin(SandboxPlugin);
app.plugin(ConsolePlugin, {
  open: false,
});

// Some services
app.plugin(DatabasePlugin);

// Some extras
app.plugin(ExtrasInDev);

// Target plugin
app.plugin(TargetPlugin, {
  endpoint: 'https://yunomi.mycard.moe/twint',
  token: 'UR5ljseYM2fpb2EX0CxqCfGe',
  username: 'GenZakura',
  search: '#文爱 #文援 #文援姬',
  interval: 10000,
  targets: [
    {
      bot: 'sandbox:koishi',
      users: ['Alice', 'Bob'],
      channels: [{ channelId: '#' }],
    },
  ],
});

app.start();
