// import 'source-map-support/register';
import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class RetweetNotifierPluginConfig {
  constructor(config: RetweetNotifierPluginConfigLike) {}

  @SchemaProperty({
    description: 'twint-api 地址。',
    default: 'http://localhost:5000',
  })
  endpoint: string;

  @SchemaProperty({ description: 'twint-api 的密钥。', default: '_empty' })
  token: string;

  @SchemaProperty({
    description: '推特账号的 ID。',
    required: true,
  })
  username: string;

  @SchemaProperty({
    description: '搜索内容。',
  })
  search: string;

  @SchemaProperty({
    description: '追踪天数。',
    default: 2,
  })
  traceDays: number;

  @SchemaProperty({
    type: String,
    description: '发送信息，随机选一个。',
    default: ['帮忙给转个推~', '帮忙转个推~', '帮忙转个推好不好~'],
  })
  message: string[];
}

export type RetweetNotifierPluginConfigLike =
  Partial<RetweetNotifierPluginConfig>;
