import { SendTarget } from 'koishi-target-def';
import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';

class RelayConfig {
  @SchemaProperty({ description: '接收消息方。（抄送则不区分）' })
  from: SendTarget;

  @SchemaProperty({ description: '发送消息方。（抄送则不区分）' })
  to: SendTarget;

  @SchemaProperty({ type: SendTarget, description: '抄送。' })
  cc: SendTarget[];
}

@RegisterSchema()
export class RelayCoreConfig extends RelayConfig {}

@RegisterSchema()
export class RelayPluginConfig extends RelayConfig {
  constructor(config: RelayPluginConfigLike) {
    super();
  }

  @SchemaProperty({ description: '是否双边转发。', default: true })
  duplex: boolean;
}

export type RelayPluginConfigLike = Partial<RelayPluginConfig>;
