// import 'source-map-support/register';
import { RelayPluginConfig } from './config';
import {
  DefinePlugin,
  If,
  PluginDef,
  Reusable,
  StarterPlugin,
  UsePlugin,
} from 'koishi-thirdeye';
import { RelayCore } from './core';
export * from './config';

@Reusable()
@DefinePlugin({ name: 'relay' })
export default class RelayPlugin extends StarterPlugin(RelayPluginConfig) {
  @UsePlugin()
  registerCommon() {
    return PluginDef(RelayCore, {
      from: this.config.from,
      to: this.config.to,
      cc: this.config.cc,
    });
  }

  @If<RelayPlugin>((o) => o.config.duplex)
  @UsePlugin()
  registerReverse() {
    return PluginDef(RelayCore, {
      from: this.config.to,
      to: this.config.from,
      cc: this.config.cc,
    });
  }
}
