import { Bot, Logger } from 'koishi';
import {
  Apply,
  DefinePlugin,
  Inject,
  InjectLogger,
  Reusable,
  StarterPlugin,
} from 'koishi-thirdeye';
import { RelayCoreConfig } from './config';

@Reusable()
@DefinePlugin({ name: 'relay-core' })
export class RelayCore extends StarterPlugin(RelayCoreConfig) {
  @Inject(true)
  private bots: Bot[];

  @InjectLogger()
  private logger: Logger;

  @Apply()
  register() {
    const ctx = this.config.from.getContext(this.ctx);
    ctx.on('message', async (s) => {
      const ccContent = `${s.username}: ${s.content}`;
      this.logger.info(ccContent);
      try {
        await Promise.all([
          this.config.to.send(this.bots, s.content),
          ...this.config.cc.map((c) => c.send(this.bots, ccContent)),
        ]);
      } catch (e) {
        this.logger.error(`Failed to relay message ${ccContent}: ${e.message}`);
      }
    });
  }
}
