import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class PicSourceYandePluginConfig {
  @DefineSchema({
    description:
      '网站 post.json 的地址。如果使用 Konachan 则可以使用 `https://konachan.com/post.json` 。',
    default: 'https://yande.re/post.json',
    role: 'url',
  })
  endpoint: string;

  @DefineSchema({ description: '页数上限。', default: 200 })
  pageLimit: number;

  @DefineSchema({ description: '使用原始图而不是 sample 图。', default: true })
  useOriginal: boolean;
}
