// import 'source-map-support/register';
import { InstanceConfig, PicSourceYandePluginConfig } from './config';
import {
  DefinePlugin,
  BasePlugin,
  Inject,
  LifecycleEvents,
} from 'koishi-thirdeye';
import PicsContainer, { PicSource } from 'koishi-plugin-pics';
import { Context, Random } from 'koishi';
import { PicInfo } from './def';
export * from './config';

export class PicSourceInstance extends PicSource {
  constructor(ctx: Context, private config: InstanceConfig) {
    super(ctx);
    config.applyTo(this);
  }

  private page = 1;
  private nextPage() {
    const currentPage = this.page;
    if (this.page >= this.config.pageLimit) {
      this.page = 1;
    } else {
      ++this.page;
    }
    return currentPage;
  }

  async randomPic(picTags: string[]) {
    const page = this.nextPage();
    const data = await this.ctx.http.get<PicInfo[]>(this.config.endpoint, {
      params: {
        tags: picTags.length ? picTags.join('+') : undefined,
        limit: 1000,
        page: page,
      },
    });
    if (!Array.isArray(data)) {
      return;
    }
    if (data.length === 0) {
      if (page === 1) {
        return;
      }
      this.page = 1;
      return this.randomPic(picTags);
    }
    const matchingData = picTags.length
      ? data.filter((d) => d.tags.split(' ').some((t) => picTags.includes(t)))
      : data;
    if (!matchingData.length) {
      return;
    }
    const pic = Random.pick(matchingData);
    return {
      url: this.config.useOriginal ? pic.file_url : pic.sample_url,
      description: `#${pic.id} ${pic.tags} by ${pic.author}`,
    };
  }
}

@DefinePlugin({ name: 'picsource-yande', schema: PicSourceYandePluginConfig })
export default class PicSourceYandePlugin
  extends BasePlugin<PicSourceYandePluginConfig>
  implements LifecycleEvents
{
  @Inject(true)
  private pics: PicsContainer;

  onApply() {
    for (const instanceConfig of this.config.instances) {
      this.pics.addSource(new PicSourceInstance(this.ctx, instanceConfig));
    }
  }
}
