// import 'source-map-support/register';
import { PicSourceYandePluginConfig } from './config';
import { DefinePlugin, Inject, ParentPlugin } from 'koishi-thirdeye';
import { PicSourcePlugin } from 'koishi-plugin-pics';
import { Random, Quester } from 'koishi';
import { PicInfo } from './def';
export * from './config';

@DefinePlugin()
export default class PicSourceYande extends PicSourcePlugin(
  PicSourceYandePluginConfig,
) {
  @Inject(true)
  private http: Quester;

  private page = 1;
  private nextPage() {
    const currentPage = this.page;
    if (this.page >= this.config.pageLimit) {
      this.page = 1;
    } else {
      ++this.page;
    }
    return currentPage;
  }

  async randomPic(picTags: string[]) {
    const page = this.nextPage();
    const data = await this.http.get<PicInfo[]>(this.config.endpoint, {
      params: {
        tags: picTags.length ? picTags.join('+') : undefined,
        limit: 1000,
        page: page,
      },
    });
    if (!Array.isArray(data)) {
      return;
    }
    if (data.length === 0) {
      if (page === 1) {
        return;
      }
      this.page = 1;
      return this.randomPic(picTags);
    }
    const matchingData = picTags.length
      ? data.filter((d) => d.tags.split(' ').some((t) => picTags.includes(t)))
      : data;
    if (!matchingData.length) {
      return;
    }
    const pic = Random.pick(matchingData);
    return {
      url: this.config.useOriginal ? pic.file_url : pic.sample_url,
      description: `#${pic.id} ${pic.tags} by ${pic.author}`,
    };
  }
}
