import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';
import { PicSourceConfig } from 'koishi-plugin-pics';

@RegisterSchema()
export class InstanceConfig extends PicSourceConfig {
  @DefineSchema({
    description:
      '网站 post.json 的地址。如果使用 Konachan 则可以使用 `https://konachan.com/post.json` 。',
    default: 'https://yande.re/post.json',
    role: 'url',
  })
  endpoint: string;

  @DefineSchema({ description: '页数上限。', default: 200 })
  pageLimit: number;

  @DefineSchema({ description: '使用原始图而不是 sample 图。', default: true })
  useOriginal: boolean;
}

@RegisterSchema()
export class PicSourceYandePluginConfig {
  constructor(config: PicSourceYandePluginConfigLike) {}

  @DefineSchema({
    description: '实例列表。',
    type: InstanceConfig,
    default: [
      { name: 'yande', url: 'https://yande.re/post.json' },
      { name: 'konachan', url: 'https://konachan.com/post.json' },
    ],
  })
  instances: InstanceConfig[];
}

export type PicSourceYandePluginConfigLike =
  Partial<PicSourceYandePluginConfig>;
