import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';
import { PicSourceInfo } from 'koishi-plugin-pics';

@RegisterSchema()
export class InstanceConfig implements PicSourceInfo {
  @DefineSchema({ description: '图源名称', default: 'yande' })
  name: string;
  @DefineSchema({ type: 'string', default: [], description: '图源标签' })
  tags: string[];
  @DefineSchema({ default: 1, description: '图源权重' })
  weight: number;
  @DefineSchema({ description: '图源描述' })
  description?: string;
  @DefineSchema({ description: '是否为默认图源' })
  isDefault?: boolean;
  @DefineSchema({
    description: '网站 post.json 的地址',
    default: 'https://yande.re/post.json',
  })
  endpoint: string;

  // 给目标对象注入上述对象。
  applyTo(target: PicSourceInfo) {
    target.tags = this.tags;
    target.weight = this.weight;
    target.name = this.name;
    target.description = this.description;
    target.isDefault = this.isDefault;
  }
}

@RegisterSchema()
export class PicSourceYandePluginConfig {
  constructor(config: PicSourceYandePluginConfigLike) {}

  @DefineSchema({ description: '实例列表。', type: InstanceConfig })
  instances: InstanceConfig[];
}

export type PicSourceYandePluginConfigLike = Partial<PicSourceYandePluginConfig>;
