import { PicSourceTwitterConfig } from './config';
import { DefinePlugin, Inject } from 'koishi-thirdeye';
import { Quester, Random } from 'koishi';
import { PicSourcePlugin } from 'koishi-plugin-pics';
export * from './config';

@DefinePlugin()
export default class PicSourceTwitter extends PicSourcePlugin(
  PicSourceTwitterConfig,
) {
  async randomPic(tags: string[]) {
    const result = await this.http.post<{
      success: boolean;
      message: string;
      data: { photos: string[]; tweet: string }[];
    }>(
      `${this.config.endpoint}/Search`,
      {
        Search: tags.length ? tags.join(' ') : undefined,
        Limit: 1,
        Images: true,
        ...this.config.extraQuery,
      },
      { headers: { Authorization: `Bearer ${this.config.token}` } },
    );
    if (!result?.data?.length) {
      return;
    }
    const tweetsWithPhoto = result.data.filter((t) => t.photos?.length);
    const tweet = Random.pick(tweetsWithPhoto);
    if (!tweet) {
      return;
    }
    const tweetContent = tweet.tweet.replace(/https:\/\/t.co\/.*$/, '').trim();
    return {
      url: Random.pick(tweet.photos),
      description: tweetContent,
    };
  }
}
