import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';
import { Dict, Schema } from 'koishi';

@RegisterSchema()
export class PicSourceTwitterConfig {
  constructor(config: PicSourceTwitterConfigLike) {}

  @SchemaProperty({ default: 'twitter' })
  name: string;

  @SchemaProperty({
    description: 'twint-api 地址。',
    default: 'http://localhost:5000',
  })
  endpoint: string;

  @SchemaProperty({ description: 'twint-api 的密钥。', default: '_empty' })
  token: string;

  @SchemaProperty({
    description: '额外查询配置。',
    default: {},
    type: Schema.object({}),
  })
  extraQuery: Dict<any>;
}

export type PicSourceTwitterConfigLike = Partial<PicSourceTwitterConfig>;
