// import 'source-map-support/register';
import { PicSourceSinaConfig } from './config';
import { DefinePlugin, Inject } from 'koishi-thirdeye';
import { Quester } from 'koishi';
import { PicSourcePlugin } from 'koishi-plugin-pics';
export * from './config';

@DefinePlugin()
export default class PicSourceSina extends PicSourcePlugin(
  PicSourceSinaConfig,
) {
  override async randomPic(tags: string[]) {
    const data = await this.http.get(this.config.getUrl(), {
      params: {
        format: 'json',
        lx: tags[0] || undefined,
        ...this.config.extraParams,
      },
    });
    return { url: data.imgurl };
  }
}
