// import 'source-map-support/register';
import { Dict, Schema } from 'koishi';
import { SchemaProperty, RegisterSchema } from 'koishi-thirdeye';

@RegisterSchema()
export class PicSourceSinaConfig {
  constructor(config: PicSourceSinaConfigLike) {}

  @SchemaProperty({ default: 'sina' })
  name: string;

  @SchemaProperty({
    default: 'https://api.btstu.cn',
    description: '请求地址。',
  })
  endpoint: string;

  @SchemaProperty({
    default: 'sjbz',
    description: '图片类型，在 api 路径中。',
  })
  category: string;

  getUrl() {
    return `${this.endpoint}/${this.category}/api.php`;
  }

  @SchemaProperty({ default: {}, type: Schema.object({}), hidden: true })
  extraParams: Dict<string | number>;
}

export type PicSourceSinaConfigLike = Partial<PicSourceSinaConfig>;
